/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.client.gui.screens;

import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3536;
import net.minecraft.class_437;
import org.betterx.bclib.client.gui.screens.AtomicProgressListener;
import org.betterx.bclib.client.gui.screens.ProgressLogoRender;
import org.betterx.ui.ColorUtil;
import org.betterx.ui.layout.components.HorizontalStack;
import org.betterx.ui.layout.components.LayoutComponent;
import org.betterx.ui.layout.components.MultiLineText;
import org.betterx.ui.layout.components.Text;
import org.betterx.ui.layout.components.VerticalStack;
import org.betterx.ui.vanilla.LayoutScreen;
import org.jetbrains.annotations.Nullable;

public class ProgressScreen
extends LayoutScreen
implements class_3536,
AtomicProgressListener {
    static final class_2960 BCLIB_LOGO_PIXELATED_LOCATION = new class_2960("bclib", "iconpixelated.png");
    class_2561 description;
    private class_2561 stageComponent;
    private MultiLineText stage;
    private HorizontalStack stageRow;
    private Text progress;
    private ProgressLogoRender progressImage;
    private int currentProgress = 0;
    private AtomicInteger atomicCounter;

    public ProgressScreen(@Nullable class_437 parent, class_2561 title, class_2561 description) {
        super(parent, title);
        this.description = description;
    }

    @Override
    public void incAtomic(int maxProgress) {
        if (this.atomicCounter != null) {
            this.method_15410(100 * this.atomicCounter.incrementAndGet() / maxProgress);
        }
    }

    @Override
    public void resetAtomic() {
        this.method_15410(0);
        this.atomicCounter = new AtomicInteger(0);
    }

    public boolean method_25422() {
        return false;
    }

    public class_2561 getProgressComponent() {
        return this.getProgressComponent(this.currentProgress);
    }

    private class_2561 getProgressComponent(int pg) {
        return class_2561.method_43471((String)"title.bclib.progress").method_27693(": " + pg + "%");
    }

    public void method_15412(class_2561 text) {
        this.method_15414(text);
    }

    public void method_15413(class_2561 text) {
        this.method_15414(text);
        this.method_15410(0);
    }

    @Override
    public void method_15414(class_2561 text) {
        this.stageComponent = text;
        if (this.stage != null) {
            this.stage.setText(text);
        }
        if (this.stageRow != null) {
            this.stageRow.reCalculateLayout();
        }
    }

    public void method_15410(int progress) {
        if (progress != this.currentProgress) {
            this.currentProgress = progress;
            if (this.progressImage != null) {
                this.progressImage.percentage = (float)this.currentProgress / 100.0f;
            }
            if (this.progress != null) {
                this.progress.setText(this.getProgressComponent());
            }
        }
    }

    @Override
    public void method_15411() {
    }

    @Override
    protected LayoutComponent<?, ?> addTitle(LayoutComponent<?, ?> content) {
        return content;
    }

    @Override
    protected LayoutComponent<?, ?> initContent() {
        VerticalStack grid = (VerticalStack)new VerticalStack(ProgressScreen.fill(), ProgressScreen.fill()).setDebugName("grid");
        grid.addFiller();
        grid.add((LayoutComponent)this.buildTitle());
        grid.addSpacer(4);
        HorizontalStack contentRow = (HorizontalStack)((HorizontalStack)grid.addRow(ProgressScreen.fit(), ProgressScreen.fit()).centerHorizontal()).setDebugName("contentRow");
        this.progressImage = new ProgressLogoRender();
        this.progressImage.percentage = (float)this.currentProgress / 100.0f;
        contentRow.add((LayoutComponent)this.progressImage);
        contentRow.addSpacer(8);
        VerticalStack textCol = (VerticalStack)((VerticalStack)contentRow.addColumn(ProgressScreen.fit(), ProgressScreen.fit()).setDebugName("textCol")).centerVertical();
        textCol.addText(ProgressScreen.fit(), ProgressScreen.fit(), this.description);
        textCol.addSpacer(4);
        this.progress = textCol.addText(ProgressScreen.fit(), ProgressScreen.fit(), this.getProgressComponent()).setColor(ColorUtil.GRAY);
        grid.addSpacer(20);
        this.stageRow = grid.addRow(ProgressScreen.fill(), ProgressScreen.fit());
        this.stage = (MultiLineText)this.stageRow.addMultilineText(ProgressScreen.fill(), ProgressScreen.fit(), (class_2561)(this.stageComponent != null ? this.stageComponent : class_2561.method_43470((String)""))).centerHorizontal();
        grid.addFiller();
        return grid;
    }
}

